﻿using System.Windows.Forms;
using System;

namespace WindowsFormsApplication1
{
    partial class FormMain
    {
        // User clicks the "Stop" button.
        private void buttonStop_Click(object sender, EventArgs e)
        {
            // Send command to stop the motor.
            this.bld04aCommand.stopMotor();
        }



        // User clicks the "Brake" button.
        private void buttonBrake_Click(object sender, EventArgs e)
        {
            // Send command to brake the motor.
            this.bld04aCommand.brakeMotor();
        }



        // User clicks the "Run" button.
        private void buttonRun_Click(object sender, EventArgs e)
        {
            // Send command to set the motor speed.
            this.bld04aCommand.setMotorSpeed((Int16)this.hScrollBarSetSpeed.Value);

            // Send command to run the motor.
            this.bld04aCommand.runMotor();
        }



        // User clicks the "Direction = 0" button.
        private void buttonDirection0_Click(object sender, EventArgs e)
        {
            // Send command to set the motor direction to 0.
            this.bld04aCommand.setMotorDirection(0);
        }



        // User clicks the "Direction = 1" button.
        private void buttonDirection1_Click(object sender, EventArgs e)
        {
            // Send command to set the motor direction to 1.
            this.bld04aCommand.setMotorDirection(1);
        }



        // User scrolls the set speed scroll bar.
        private void hScrollBarSetSpeed_Scroll(object sender, ScrollEventArgs e)
        {
            // Update the speed value in the label.
            this.labelSetSpeed.Text = "Set Speed: " + this.hScrollBarSetSpeed.Value.ToString();

            // Send command to set the motor speed.
            this.bld04aCommand.setMotorSpeed((Int16)this.hScrollBarSetSpeed.Value);
        }



    }
}
